/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools.common;

import ch.dlcm.tools.common.DLCMTools;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SIPUploader
extends DLCMTools {
    private static final Logger log = LoggerFactory.getLogger(SIPUploader.class);

    public SIPUploader(StandaloneRestClientTool restClientTool, String ingestUrl) {
        super(restClientTool);
        this.ingestUrl = ingestUrl;
    }

    public void importSIP(String organizationalUnitId, Path folder) {
        String prefix = "[OrganizationalUnit=" + organizationalUnitId + " SIP] ";
        log.info("{} Scanning folder: {}", (Object)prefix, (Object)folder);
        int count = 0;
        for (Path d : this.scanAll(folder)) {
            ++count;
            log.info("{} Importing {}", (Object)prefix, (Object)d);
            this.sendSIP(prefix, organizationalUnitId, d);
        }
        log.info("{} Importing end {}: {} uploaded SIP file(s)", new Object[]{prefix, folder, count});
    }
}

