/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.dlcm.model.preingest.Deposit;
import ch.dlcm.tools.common.DLCMTools;
import ch.dlcm.tools.common.DepositUploader;
import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"check"})
public class DepositCheck
extends DLCMTools
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DepositCheck.class);
    @Value(value="${dlcm.load}")
    private String loadFolder;

    public DepositCheck(StandaloneRestClientTool restClientTool) {
        super(restClientTool);
    }

    public void run(String ... arg0) throws Exception {
        String prefix = "[Deposit Check]";
        if (!this.loadFolder.isEmpty()) {
            log.info("{} Scanning folder : {}", (Object)"[Deposit Check]", (Object)this.loadFolder);
            int count = 0;
            for (Path depositId : FileTool.scanFolder((Path)Paths.get(this.loadFolder, new String[0]), x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                if (Files.isHidden(depositId)) continue;
                Deposit deposit = this.findDeposit(depositId.getFileName().toString());
                if (deposit == null) {
                    log.error("{} Deposit {} does not exist", (Object)"[Deposit Check]", (Object)depositId.getFileName());
                    continue;
                }
                if (deposit.getStatus() != Deposit.DepositStatus.IN_PROGRESS) {
                    log.warn("{} Deposit {} not ready for checking: status={}", new Object[]{"[Deposit Check]", depositId.getFileName(), deposit.getStatus()});
                    continue;
                }
                log.info("{} Deposit check for {} started", (Object)"[Deposit Check]", (Object)depositId.getFileName());
                DepositUploader depositUploader = new DepositUploader(this.restClientTool, this.preIngestUrl, this.licenseId);
                depositUploader.checkDepositDatafiles("[Deposit Check]", deposit.getResId(), depositId);
                log.info("{} Deposit check for {} completed", (Object)"[Deposit Check]", (Object)depositId.getFileName());
            }
            log.info("{} Deposit checking end {} : {} processed deposit(s)", new Object[]{"[Deposit Check]", this.loadFolder, ++count});
        }
    }
}

