/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.dlcm.tools.common.AIPUploader;
import ch.dlcm.tools.common.DLCMTools;
import ch.dlcm.tools.common.DepositUploader;
import ch.dlcm.tools.common.SIPUploader;
import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"import"})
public class OrgUnitService
extends DLCMTools
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(OrgUnitService.class);
    @Value(value="${dlcm.import}")
    private String importFolder;

    public OrgUnitService(StandaloneRestClientTool restClientTool) {
        super(restClientTool);
    }

    public void run(String ... arg0) throws Exception {
        String prefix = "[OrganizationalUnit]";
        if (!this.importFolder.isEmpty()) {
            log.info("{} Scanning folder : {}", (Object)"[OrganizationalUnit]", (Object)this.importFolder);
            int count = 0;
            for (Path organizationalUnit : FileTool.scanFolder((Path)Paths.get(this.importFolder, new String[0]), x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                if (Files.isHidden(organizationalUnit)) continue;
                String orgUnitId = this.findOrganizationUnit(organizationalUnit.getFileName().toString());
                if (orgUnitId == null) {
                    orgUnitId = this.createOrganizationUnit("[OrganizationalUnit]", organizationalUnit.getFileName().toString());
                } else {
                    log.info("{} {} organizationalUnit already exist: {}", new Object[]{"[OrganizationalUnit]", organizationalUnit.getFileName(), orgUnitId});
                }
                for (Path objType : FileTool.scanFolder((Path)organizationalUnit, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                    if (objType.getFileName().toString().equalsIgnoreCase("deposit")) {
                        DepositUploader depositUploader = new DepositUploader(this.restClientTool, this.preIngestUrl, this.licenseId);
                        depositUploader.importDeposit(orgUnitId, objType);
                        continue;
                    }
                    if (objType.getFileName().toString().equalsIgnoreCase("sip")) {
                        SIPUploader sipUploader = new SIPUploader(this.restClientTool, this.ingestUrl);
                        sipUploader.importSIP(orgUnitId, objType);
                        continue;
                    }
                    if (!objType.getFileName().toString().equalsIgnoreCase("aip")) continue;
                    AIPUploader aipUploader = new AIPUploader(this.restClientTool, this.archivalStorageUrl);
                    aipUploader.importAIP(orgUnitId, objType);
                }
                ++count;
            }
            log.info("{} Importing end {} : {} processed organizationalUnit(s)", new Object[]{"[OrganizationalUnit]", this.importFolder, count});
        }
    }
}

